
*___________________________________________________________________________________________________

	VAR Price and Trade 01.sas

	Estimate a VAR of prices and trade directions (real data).

	This program uses the VarianceDecomp macro (in the '/SAS macros' subdirectory).

____________________________________________________________________________________________________;

*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\EMM Distribution\SAS Programs v0100';
options nodate nocenter nonumber ps=70 ls=120  sasautos=('./Sas Macros','.') nomprint; 
libname SASData '.\Datasets';

ods pdf file='./VAR Price and Trade 01.pdf' style=serifPrinter;

title 'VAR Price and Trade 01.sas';

*	Build dataset with signed trades and prices.;
data cq;
	set SASData.cq;
	where ex='N' and bidsiz>0 and ofrsiz>0 and bid>0 and ofr>0 and ofr-bid<5;
	by symbol date time;
	if last.time then output;
data ct;
	set SASData.ct (in=inT) cq (in=inQ);
	by symbol date time;
	retain qmid;
	if first.date then qmid=.;
	if inQ then qmid = (bid+ofr)/2;
	if inT and not missing(qmid) then do;
		q = sign( round(price-qmid,0.000001) );
		effcost = abs(price-qmid);
		p = price;
		keep symbol date time price size q ex qmid p effcost;
		output;
	end;
	run;
proc print data=ct (obs=60) noobs;
	by symbol date;
	title2 "Signed trades in MTZ, October, 2005";
	run;
proc univariate data=ct;
	var effcost;
	run;
*__________________________________________________________________________________________________;
%let nImpulse=10;
title2 'Analysis of prices and order flow.';
proc varmax data=ct;
	model q p / p=4 dif=(p(1)) noint print=(impulse(&nImpulse)=(accum ortho)) lagmax=0 ;
	ods output covInnovation=covInnovation;
	ods output accumImpulse=accumImpulse;
	ods output orthoImpulse=orthoImpulse;
	run;
data lastAccumImpulse;
	set accumImpulse;
	where lag=&nImpulse and variable='p';
	drop lag;
	run;
*	Examine alternative variance decompositions;
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastAccumImpulse, RowLabel=variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastAccumImpulse, RowLabel=variable, perm=p q);

*__________________________________________________________________________________________________;
*	Analyze dynamics subsequent to a buy order.

	The orthogonalized impulse response functions produce by proc varmax
	assume a one-sd initial shock. Rescale by the sd of the q innovation
	to make the shock correspond to q=1 (a buy order).;
*__________________________________________________________________________________________________;
data qImpact;
	if _n_=1 then do;
		set covInnovation;
		std_q = sqrt(q);
		retain std_q;
	end;
	set orthoImpulse;
	q = q/std_q;
	keep lag q variable;
	rename lag=t;
proc transpose data=qImpact out=qImpactT (drop=_name_);
	var q;
	id variable;
	by t;
	run;
*	Cumulate the trade and price impacts;
data cumImpact;
	retain q 0 p 0;
	do i=0 to &nImpulse;
		set qImpactT (rename=(q=qCurrent p=pCurrent));
		q = q + qCurrent;
		p = p + pCurrent;
		output;
		keep t q p qCurrent pCurrent;
	end;
proc print data=CumImpact;
	title2 'Impact of a buy order (q=+1 at time 0)';
	run;
symbol1 v=dot;
goptions htext=2 ftext=duplex;
proc gplot data=cumImpact;
	plot p*t / hzero vzero;
	run;
	quit;
proc gplot data=cumImpact;
	plot q*t / hzero vzero;
	run;
	quit;

ods _all_ close;
